package com.elitesland.cbpl.infinity.client.config;

import com.elitesland.cbpl.infinity.client.security.registrar.InfinityMvcConfigurer;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.infinity.client.config.InfinityClientProperties.INFINITY_CLIENT_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/06/14
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(InfinityClientProperties.class)
@ConditionalOnProperty(prefix = INFINITY_CLIENT_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class InfinityClientAutoConfiguration {

    @Bean
    @ConditionalOnClass
    public InfinityMvcConfigurer infinityMvcConfigurer(InfinityAccountService accountService) {
        return new InfinityMvcConfigurer(accountService);
    }
}
