package com.elitesland.cbpl.infinity.server.account.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 对外提供接口的认证账号
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@ApiModel("对外提供接口的认证账号")
public class InfinityAccountRespVO {

    @ApiModelProperty("账号ID")
    private Long id;

    @ApiModelProperty("所属租户ID")
    private Long belongTenant;

    @ApiModelProperty("认证账号")
    private String username;

    @ApiModelProperty("认证密码")
    private String password;

    @ApiModelProperty("拦截地址：逗号分隔")
    private String interceptUri;

    @ApiModelProperty("平台编码：WMS、BOH、美团、旺店通等")
    private String platformCode;

    @ApiModelProperty("自定义标签")
    private String tags;

    public List<String> getInterceptUriList() {
        return List.of(interceptUri.split(","));
    }
}
