package com.elitesland.cbpl.infinity.server.platform.vo.resp;

import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 接口平台(对接系统)
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@ApiModel("接口平台(对接系统)")
public class PlatformRespVO {

    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台名称")
    private String platformName;

    @ApiModelProperty(value = "平台编码")
    private String platformCode;

    @ApiModelProperty(value = "服务url前缀")
    private String serverUrl;

    @ApiModelProperty(value = "认证方式")
    private String authMethod;

    @ApiModelProperty(value = "认证方式中文")
    private String authMethodName;

    @ApiModelProperty(value = "认证账号")
    private String authAccount;

    @ApiModelProperty(value = "BasicAuth 认证账号")
    private BasicAuthAccountVO basicAuthAccount;

    @ApiModelProperty(value = "OAuth2.0 认证账号")
    private OAuth2AccountVO oauth2Account;

    @ApiModelProperty(value = "文档说明(支持markdown)")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;
}
