package com.elitesland.cbpl.infinity.web.http.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.web.http.domain.InfinityResult;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.infinity.web.http.vo.InvokeParam;
import com.elitesland.cbpl.tool.core.map.MapUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/05/20
 */
@Slf4j
@Api(tags = "接口调用")
@RestController
@RequestMapping("/infinity/web")
@RequiredArgsConstructor
public class InfinityWebController {

    private final InfinityRestClient restClient;

    @ApiOperation(value = "执行一次")
    @PostMapping("/invoke/{apiCode}")
    public Object invoke(@PathVariable("apiCode") String apiCode, @RequestBody InvokeParam payload) {
        InfinityResult<Object> resp = restClient.exchange(apiCode, Object.class, (builder) -> {
            if (StrUtil.isNotBlank(payload.getBizKey())) {
                builder.bizKey(payload.getBizKey());
            }
            if (MapUtil.isNotEmpty(payload.getHeaderParam())) {
                builder.headerParam(MapUtils.convert(payload.getHeaderParam()));
            }
            if (MapUtil.isNotEmpty(payload.getQueryParam())) {
                builder.queryParam(MapUtils.convert(payload.getQueryParam()));
            }
            if (MapUtil.isNotEmpty(payload.getPathParam())) {
                builder.pathParam(payload.getPathParam());
            }
            if (ObjectUtil.isNotNull(payload.getBodyParam())) {
                builder.bodyParam(payload.getBodyParam());
            }
            if (ObjectUtil.isNotNull(payload.getBodyParam())) {
                builder.bodyParam(payload.getBodyParam());
            }
            if (ObjectUtil.isNotNull(payload.getFormParam())) {
                builder.bodyParam(convert(payload.getFormParam()));
            }
            return builder.build();
        });
        return resp.toEntity();
    }

    private MultiValueMap<String, Object> convert(Map<String, Object[]> multivalueMap) {
        MultiValueMap<String, Object> map = new LinkedMultiValueMap<>();

        for (Map.Entry<String, Object[]> entry : multivalueMap.entrySet()) {
            map.addAll(entry.getKey(), List.of(entry.getValue()));
        }

        return map;
    }
}
