package com.elitesland.cbpl.infinity.web.security.domain;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/06/07
 */
@Data
public class OAuth2AccountVO {

    /**
     * 认证地址
     */
    private String url;

    /**
     * AppId or ClientId
     */
    private String clientId;

    /**
     * AppSecret or ClientSecret
     */
    private String clientSecret;

    @JsonIgnore
    public boolean isEmpty() {
        return StrUtil.isBlank(url) || StrUtil.isBlank(clientId) || StrUtil.isBlank(clientSecret);
    }
}