package com.elitesland.cbpl.infinity.web.security.service.weaver.domain;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/08/22
 */
@Data
@ApiModel("认证账号")
public class WeaverAccountVO {

    // ======== 接口信息 ======== //

    @ApiModelProperty(value = "平台编码")
    private String platformCode;

    @ApiModelProperty(value = "分组id")
    private Long folderId;

    @ApiModelProperty(value = "接口编码")
    private String apiCode;

    // ======== 认证信息 ======== //

    @ApiModelProperty(value = "服务地址")
    private String serverUrl;

    @ApiModelProperty("许可证号码")
    private String appid;

    /**
     * 默认1800秒
     */
    @ApiModelProperty("过期时间，单位：秒")
    private String time = "1800";

    /**
     * 是否跳过session拦截(用于白名单接口)，1代表是，0代表否（缺省）
     */
    @ApiModelProperty("跳过session拦截")
    private String skip = "0";

    @ApiModelProperty("相关缓存key的前缀")
    private String prefix = "WV_";

    @JsonIgnore
    public boolean isEmpty() {
        return StrUtil.isBlank(serverUrl) || StrUtil.isBlank(appid);
    }

    /**
     * 过期时间，单位：秒<br/>
     * 如果大于10分钟，则减5分钟
     */
    @JsonIgnore
    public long getExpiresIn() {
        long expiresIn = Long.parseLong(time);
        if (expiresIn > 600) {
            return expiresIn - 300;
        }
        return expiresIn;
    }
}
