package com.elitesland.cbpl.infinity.web.security.service.weaver.e9.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.infinity.web.security.service.weaver.domain.WeaverAccountVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util.WeaverE9Util;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

import java.util.List;

import static com.elitesland.cbpl.common.constant.AuthMethod.AUTH_METHOD_WEAVER_E9;

/**
 * 泛微OA E9认证
 *
 * @author eric.hao
 * @since 2024/08/22
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("WEAVER_E9")
public class WeaverE9AuthService implements SecurityAuthService {

    private final WeaverE9Service weaverE9Service;

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        LogUtil.info("[BPMN][WEAVER-E9] 认证方式：" + AUTH_METHOD_WEAVER_E9.getDesc());
        String accountStr = param.getApiConfig().getAuthAccount();
        WeaverAccountVO accountVO = BeanUtils.toBean(accountStr, WeaverAccountVO.class);
        if (accountVO.isEmpty()) {
            LogUtil.info("[BPMN][WEAVER-E9] 未维护认证账号.");
            throw new RuntimeException("Weaver Account Empty.");
        }
        // TODO 原来是考虑每个接口都可以有自己的认证账号，及对应的公钥密钥的存储；但是没有考虑到认证账号是维护在哪个维度；导致对应关系错误，签名解密失败；
//        accountVO.setPlatformCode(param.getPlatformCode());
//        accountVO.setFolderId(param.getApiConfig().getFolderId());
//        accountVO.setApiCode(param.getApiCode());
        String accessToken = weaverE9Service.getAccessToken(accountVO);
        if (StrUtil.isBlank(accessToken)) {
            LogUtil.info("[BPMN][WEAVER-E9] token为空.");
            return false;
        }
        // token信息
        uri.header("token", accessToken);
        // 许可证号码
        uri.header("appid", accountVO.getAppid());
        // 是否跳过session拦截(用于白名单接口)，1代表是，0代表否（缺省）
        uri.header("skipsession", accountVO.getSkip());

        // 针对header中的`userId`参数，需要加密处理
        uri.headers(headers -> {
            if (headers.containsKey("userId")) {
                List<String> userIds = headers.remove("userId");
                if (CollUtil.isNotEmpty(userIds)) {
                    headers.set("userId", WeaverE9Util.encrypt(accountVO.getPrefix(), userIds.get(0)));
                }
            }
        });
        return true;
    }
}
