package com.elitesland.cbpl.infinity.bpmn.component;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import lombok.extern.slf4j.Slf4j;

/**
 * 迭代器遍历节点
 * <li>配合{@link InfinityIteratorComponent}节点使用</li>
 * <li>通过`this.getCurrLoopObj()`来获取循环对象</li>
 *
 * @author eric.hao
 * @since 2024/05/21
 */
@Slf4j
@LiteflowComponent(BpmnConstant.BPMN_NODE_CURR_LOOP)
public class InfinityCurrLoopComponent extends NodeComponent {

    @SuppressWarnings("unchecked")
    @Override
    public void process() throws Exception {
        var ctx = this.getContextBean(StandardContext.class);
        Object currLoopObj = this.getCurrLoopObj();
        // 1. 优先配合迭代组件，遍历数据
        if (ObjectUtil.isNotNull(currLoopObj)) {
            ctx.setResponse(currLoopObj);
            // LogUtil.info(null, "[BPMN][ITERATOR] 当前遍历参数: ", currLoopObj);
        }
        // 2. 其次获取上一节点出参是否有值；如果有值，则直接返回下一节点
        else if (ObjectUtil.isNotNull(ctx.getPrevParam())) {
            ctx.setResponse(ctx.getPrevParam());
            // LogUtil.info(null, "[BPMN][ITERATOR] 前节点传递参数: ", ctx.getPrevParam());
        }
        // 3. 无入参
        else {
            LogUtil.info(null, "[BPMN][ITERATOR] 无任何入参.");
        }
    }
}
