package com.elitesland.cbpl.infinity.client.config;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.infinity.client.config.InfinityClientProperties.INFINITY_CLIENT_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/06/14
 */
@Data
@ConfigurationProperties(prefix = INFINITY_CLIENT_CONFIG_PREFIX)
public class InfinityClientProperties implements InitializingBean {

    public static final String INFINITY_CLIENT_CONFIG_PREFIX = "cbpl.infinity.client";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    public static boolean INFINITY_CLIENT_ENABLED;

    @Override
    public void afterPropertiesSet() throws Exception {
        INFINITY_CLIENT_ENABLED = enabled;
    }
}
