package com.elitesland.cbpl.infinity.client.security.registrar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.security.interceptor.AuthInterceptor;
import com.elitesland.cbpl.infinity.client.security.spi.InfinityAuthListener;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Slf4j
@RequiredArgsConstructor
public class InfinityMvcConfigurer implements WebMvcConfigurer {

    private final InfinityAccountService accountService;

    private Map<String, List<InfinityAccountRespVO>> interceptors;

    @Override
    public void addInterceptors(@Nonnull InterceptorRegistry registry) {
        boolean isPresent = SpringUtils.isPresent(InfinityAuthListener.class);
        // 注册拦截器
        interceptorMap().forEach((interceptUri, acc) -> registry.addInterceptor(
                isPresent ? new AuthInterceptor(acc, SpringUtils.getBean(InfinityAuthListener.class)) : new AuthInterceptor(acc)
        ).addPathPatterns(interceptUri));
    }

    private Map<String, List<InfinityAccountRespVO>> interceptorMap() {
        if (ObjectUtil.isNotNull(interceptors)) {
            return interceptors;
        }
        var accounts = accountService.infinityAccountByParam(new InfinityAccountQueryParamVO());
        Map<String, List<InfinityAccountRespVO>> interceptors = new HashMap<>();
        for (var account : accounts) {
            for (String interceptUri : account.getInterceptUriList()) {
                var acc = interceptors.get(interceptUri);
                if (CollUtil.isEmpty(acc)) {
                    acc = new ArrayList<>();
                }
                acc.add(account);
                interceptors.put(interceptUri, acc);
            }
        }
        this.interceptors = interceptors;
        return interceptors;
    }
}
