package com.elitesland.cbpl.infinity.client.security.session.domain;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/06/28
 */
@Data
public class InfinityUser {

    @ApiModelProperty("账号ID")
    private Long id;

    @ApiModelProperty("所属租户ID")
    private Long belongTenant;

    @ApiModelProperty("认证账号")
    private String username;

    @ApiModelProperty("平台编码：WMS、BOH、美团、旺店通等")
    private String platformCode;

    @ApiModelProperty("自定义标签")
    private String tags;

    @ApiModelProperty("拦截地址：逗号分隔")
    private String interceptUri;

    public List<String> getInterceptUriList() {
        return List.of(interceptUri.split(","));
    }
}
