package com.elitesland.cbpl.infinity.common.controller;

import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.infinity.common.service.AuthMethodService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/27
 */
@Slf4j
@Api(tags = "通用接口")
@RestController
@RequestMapping("/infinity/common")
@AllArgsConstructor
public class InfinityCommonApi {

    private final AuthMethodService authMethodService;

    @ApiOperation(value = "认证方式")
    @GetMapping(value = "/auth_method")
    public HttpResult<List<EnumValues>> authMethod() {
        return HttpResult.ok(authMethodService.authMethod());
    }
}
