package com.elitesland.cbpl.infinity.common.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.common.service.AuthMethodService;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cbpl.unicom.domain.InvokeTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/07/16
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag(InvokeTag.TAG_GENERAL)
public class DefaultAuthMethodService implements AuthMethodService {
    @Override
    public List<EnumValues> authMethod() {
        return Arrays.stream(AuthMethod.values())
                .map(name -> EnumValues.of(name.getCode(), name.getDesc()))
                .collect(Collectors.toList());
    }

    @Override
    public Map<String, String> fromCode(List<String> authMethodCodes) {
        Map<String, String> authMethodNames = new HashMap<>();
        if (CollUtil.isEmpty(authMethodCodes)) {
            return authMethodNames;
        }
        for (String authMethodCode : authMethodCodes) {
            authMethodNames.put(authMethodCode, AuthMethod.fromCode(authMethodCode));
        }
        return authMethodNames;
    }
}
