package com.elitesland.cbpl.infinity.server.api.service;

import com.elitesland.cbpl.infinity.server.api.vo.param.ApiQueryParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiSaveParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiDetailVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
public interface InfinityApiService {

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<InfinityApiRespVO> infinityApiByParam(ApiQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    InfinityApiDetailVO infinityApiById(Long id);

    /**
     * 明细查询
     *
     * @param apiCode 接口编码
     * @return 接口
     */
    InfinityApiDetailVO infinityApiByApiCode(String apiCode);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ApiSaveParamVO saveParam);

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    void updateStatus(Long id, int status);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    long delete(List<Long> ids);
}
