package com.elitesland.cbpl.infinity.server.security.convert;

import com.elitesland.cbpl.infinity.server.security.entity.InfinitySecurityDO;
import com.elitesland.cbpl.infinity.server.security.vo.param.InfinitySecuritySaveParamVO;
import com.elitesland.cbpl.infinity.server.security.vo.resp.InfinitySecurityDetailVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/08/26
 */
@Mapper(config = BaseMapperConfig.class)
public interface InfinitySecurityConvert {

	InfinitySecurityConvert INSTANCE = Mappers.getMapper(InfinitySecurityConvert.class);

    /**
     * DO => RespVO
     */
    InfinitySecurityDetailVO doToVO(InfinitySecurityDO infinitySecurityDO);

    /**
     * SaveParam => DO
     */
    InfinitySecurityDO saveParamToDO(InfinitySecuritySaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(InfinitySecuritySaveParamVO saveParam, @MappingTarget InfinitySecurityDO infinitySecurityDO);
}
