package com.elitesland.cbpl.infinity.server.security.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 接口认证方式扩展表(用于动态数据持久化)
 *
 * @author eric.hao
 * @since 2024/08/26
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_infinity_security_storage")
@org.hibernate.annotations.Table(appliesTo = "sys_infinity_security_storage", comment = "接口认证方式扩展表(用于动态数据持久化)")
@ApiModel("接口认证方式扩展表(用于动态数据持久化)")
public class InfinitySecurityDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 2423589442395299156L;

	/**
	 * 平台编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "平台编码")
	@Column(name = "platform_code", nullable = true, length = 64)
	private String platformCode;

	/**
	 * 分组id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "分组id")
	@Column(name = "folder_id", nullable = true, length = 20)
	private Long folderId;

	/**
	 * 接口编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "接口编码")
	@Column(name = "api_code", nullable = true, length = 64)
	private String apiCode;

	/**
	 * 客户端公钥
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "客户端公钥")
	@Column(name = "local_public_key", nullable = true, length = 32)
	private String localPublicKey;

	/**
	 * 客户端私钥
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "客户端私钥")
	@Column(name = "local_private_key", nullable = true, length = 32)
	private String localPrivateKey;

	/**
	 * 服务端公钥
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "服务端公钥")
	@Column(name = "server_public_key", nullable = true, length = 32)
	private String serverPublicKey;

	/**
	 * 服务端密钥
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "服务端密钥")
	@Column(name = "server_secret", nullable = true, length = 32)
	private String serverSecret;
}
