package com.elitesland.cbpl.infinity.server.security.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.security.entity.QInfinitySecurityDO;
import com.elitesland.cbpl.infinity.server.security.vo.param.InfinitySecuritySaveParamVO;
import com.elitesland.cbpl.infinity.server.security.vo.resp.InfinitySecurityDetailVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/26
 */
@Component
@RequiredArgsConstructor
public class InfinitySecurityRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinitySecurityDO infinitySecurityDO = QInfinitySecurityDO.infinitySecurityDO;

    private final QBean<InfinitySecurityDetailVO> infinitySecurityVO = Projections.bean(
            InfinitySecurityDetailVO.class,
            infinitySecurityDO.id,
            infinitySecurityDO.platformCode,
            infinitySecurityDO.folderId,
            infinitySecurityDO.apiCode,
            infinitySecurityDO.localPublicKey,
            infinitySecurityDO.localPrivateKey,
            infinitySecurityDO.serverPublicKey,
            infinitySecurityDO.serverSecret,
            infinitySecurityDO.tenantId,
            infinitySecurityDO.remark,
            infinitySecurityDO.createUserId,
            infinitySecurityDO.creator,
            infinitySecurityDO.createTime,
            infinitySecurityDO.modifyUserId,
            infinitySecurityDO.updater,
            infinitySecurityDO.modifyTime,
            infinitySecurityDO.deleteFlag
    );

    private Predicate where(InfinitySecuritySaveParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(infinitySecurityDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getPlatformCode())) {
            predicates.add(infinitySecurityDO.platformCode.eq(query.getPlatformCode()));
        }
        if (ObjectUtil.isNotNull(query.getFolderId())) {
            predicates.add(infinitySecurityDO.folderId.eq(query.getFolderId()));
        }
        if (StrUtil.isNotBlank(query.getApiCode())) {
            predicates.add(infinitySecurityDO.apiCode.eq(query.getApiCode()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinitySecurityDetailVO> infinitySecurityByParam(InfinitySecuritySaveParamVO query) {
        var jpaQuery = jpaQueryFactory.select(infinitySecurityVO)
                .from(infinitySecurityDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }
}
