package com.elitesland.cbpl.infinity.web.config.provider;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import lombok.RequiredArgsConstructor;

import java.net.SocketAddress;

/**
 * DNS 解析缓存
 *
 * @author eric.hao
 * @version 0.3.6-SNAPSHOT
 * @since 2025/03/07
 */
@RequiredArgsConstructor
public class DnsCacheHandler extends ChannelOutboundHandlerAdapter {

    /**
     * 有效缓存时间，单位秒
     */
    private final int ttl;

    /**
     * 失败结果的有效缓存时间，单位秒
     */
    private final int negativeTtl;

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress,
                        SocketAddress localAddress, ChannelPromise promise) {
        DnsNameResolverBuilder resolverBuilder = new DnsNameResolverBuilder(ctx.channel().eventLoop())
                .ttl(ttl, ttl).negativeTtl(negativeTtl);
        ctx.pipeline().replace(this, "dnsResolver", (ChannelHandler) resolverBuilder.build());
        ctx.connect(remoteAddress, localAddress, promise);
    }
}