package com.elitesland.cbpl.infinity.web.security.service.weaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/08/22
 */
@Data
public class WeaverRespVO {

    @ApiModelProperty("响应状态。true:成功,false:失败")
    private Boolean status;

    @ApiModelProperty("响应码。0代表成功")
    private String code;

    @ApiModelProperty("响应信息")
    private String msg;

    @ApiModelProperty("信息显示类型。默认“none”")
    private String msgShowType;

    @JsonIgnore
    public boolean success() {
        return status != null && status;
    }

    @JsonIgnore
    public boolean failed() {
        return !success();
    }
}
