package com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util;

import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/08/22
 */
public class WeaverE9Key {

    // 暂仅支持单机缓存
    private static final Map<String, String> SYSTEM_CACHE = new HashMap<>();
    // 服务端公钥
    private static final String E9_SERVER_PUBLIC_KEY = "SERVER_PUBLIC_KEY";
    // 服务端密钥
    private static final String E9_SERVER_SECRET = "SERVER_SECRET";

    /**
     * 读取服务端公钥
     */
    public static String getServerPublicKey(String prefix) {
        return SYSTEM_CACHE.get(prefix + E9_SERVER_PUBLIC_KEY);
    }

    /**
     * 读取服务端密钥
     */
    public static String getServerSecret(String prefix) {
        return SYSTEM_CACHE.get(prefix + E9_SERVER_SECRET);
    }

    /**
     * 添加系统缓存
     *
     * @param prefix key前缀
     * @param spk    服务端公钥
     * @param secret 服务端密钥
     */
    public static void setCache(String prefix, String spk, String secret) {
        // ECOLOGY返回的系统公钥
        SYSTEM_CACHE.put(prefix + E9_SERVER_PUBLIC_KEY, spk);
        // ECOLOGY返回的系统密钥
        SYSTEM_CACHE.put(prefix + E9_SERVER_SECRET, secret);
    }

    /**
     * 删除系统缓存
     */
    public static void removeCache() {
        SYSTEM_CACHE.clear();
    }
}
