package com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.elitesland.cbpl.infinity.web.security.service.weaver.constant.WeaverApiConstant;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/22
 */
public class WeaverE9Util {

    /**
     * 数据加密
     */
    public static String encrypt(String prefix, String data) {
        RSA rsa = new RSA(null, WeaverE9Key.getServerPublicKey(prefix));
        return rsa.encryptBase64(data, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
    }


    /**
     * {WEAVER_E9_CACHE_TOKEN_KEY}_{appid}_{租户ID}
     */
    public static String tokenKey(String appid) {
        List<String> values = ListUtil.toList(WeaverApiConstant.WEAVER_E9_CACHE_TOKEN_KEY, appid);
        // 租户
        String tenantCode = TenantSpiUtil.currentTenantCode();
        if (StrUtil.isNotBlank(tenantCode)) {
            values.add(tenantCode);
        }
        return StrUtil.join(StrPool.UNDERLINE, values);
    }
}
