/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.bpmn.component;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.data.etl.util.DataETL;
import com.elitesland.cbpl.infinity.common.constant.DataType;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LiteflowComponent(value="__transform")
public class InfinityTransformComponent
extends NodeComponent {
    private static final Logger logger = LoggerFactory.getLogger(InfinityTransformComponent.class);
    private static final String TRANSFORM_TEMPLATE_CODE = "TTC";
    private static final String TRANSFORM_RESPONSE_TYPE = "TRT";

    public void process() throws Exception {
        Map nodeParam = (Map)this.getCmpData(Map.class);
        StandardContext ctx = (StandardContext)this.getContextBean(StandardContext.class);
        String templateCode = nodeParam.getOrDefault(TRANSFORM_TEMPLATE_CODE, "").toString();
        if (StrUtil.isBlank((CharSequence)templateCode)) {
            LogUtil.info((String)"[BPMN][ETL] \u6a21\u7248\u7f16\u7801\u4e3a\u7a7a.");
            return;
        }
        LogUtil.info((String)("[BPMN][ETL] \u6a21\u677f\u7f16\u7801: " + templateCode));
        Object prevParam = ctx.getPrevParam();
        String result = DataETL.transform((String)templateCode, (Object)prevParam);
        String responseType = String.valueOf(nodeParam.get(TRANSFORM_RESPONSE_TYPE));
        if (StrUtil.isNullOrUndefined((CharSequence)responseType)) {
            ctx.setResponse((Object)result);
        } else if (responseType.equals(DataType.Object.getCode())) {
            ctx.setResponse((Object)BeanUtils.toMap((String)result));
        } else if (responseType.equals(DataType.Array.getCode())) {
            ctx.setResponse((Object)BeanUtils.toMapList((String)result));
        }
    }
}

