/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.security.registrar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.security.interceptor.AuthInterceptor;
import com.elitesland.cbpl.infinity.client.security.spi.InfinityAuthListener;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class InfinityMvcConfigurer
implements WebMvcConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(InfinityMvcConfigurer.class);
    private final InfinityAccountService accountService;
    private Map<String, List<InfinityAccountRespVO>> interceptors;

    public void addInterceptors(@Nonnull InterceptorRegistry registry) {
        boolean isPresent = SpringUtils.isPresent(InfinityAuthListener.class);
        this.interceptorMap().forEach((interceptUri, acc) -> registry.addInterceptor((HandlerInterceptor)(isPresent ? new AuthInterceptor((List<InfinityAccountRespVO>)acc, (InfinityAuthListener)SpringUtils.getBean(InfinityAuthListener.class)) : new AuthInterceptor((List<InfinityAccountRespVO>)acc))).addPathPatterns(new String[]{interceptUri}));
    }

    private Map<String, List<InfinityAccountRespVO>> interceptorMap() {
        if (ObjectUtil.isNotNull(this.interceptors)) {
            return this.interceptors;
        }
        List<InfinityAccountRespVO> accounts = this.accountService.infinityAccountByParam(new InfinityAccountQueryParamVO());
        HashMap<String, List<InfinityAccountRespVO>> interceptors = new HashMap<String, List<InfinityAccountRespVO>>();
        for (InfinityAccountRespVO account : accounts) {
            for (String interceptUri : account.getInterceptUriList()) {
                ArrayList<InfinityAccountRespVO> acc = (ArrayList<InfinityAccountRespVO>)interceptors.get(interceptUri);
                if (CollUtil.isEmpty((Collection)acc)) {
                    acc = new ArrayList<InfinityAccountRespVO>();
                }
                acc.add(account);
                interceptors.put(interceptUri, acc);
            }
        }
        this.interceptors = interceptors;
        return interceptors;
    }

    public InfinityMvcConfigurer(InfinityAccountService accountService) {
        this.accountService = accountService;
    }
}

