/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.config;

import com.elitesland.cbpl.infinity.web.config.InfinityWebProperties;
import com.elitesland.cbpl.infinity.web.config.provider.DnsCacheHandler;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.infinity.web.security.service.oauth2.OAuth2Client;
import com.elitesland.cbpl.tool.core.http.RestWrapper;
import com.elitesland.cbpl.tool.redis.util.RedisUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

@Configuration
@EnableConfigurationProperties(value={InfinityWebProperties.class})
@ConditionalOnProperty(prefix="cbpl.infinity.web", name={"enabled"}, havingValue="true")
public class InfinityWebAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(InfinityWebAutoConfiguration.class);

    @Bean
    public ConnectionProvider connectionProvider(InfinityWebProperties properties) {
        return ((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)properties.getConnectionName()).maxConnections(properties.getMaxConnections())).pendingAcquireTimeout(Duration.ofSeconds(properties.getPendingAcquireTimeout()))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(InfinityWebProperties properties, ConnectionProvider connectionProvider) {
        HttpClient httpClient = ((HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)InfinityWebProperties.CONNECT_TIMEOUT)).responseTimeout(Duration.ofMillis(InfinityWebProperties.RESPONSE_TIMEOUT)).doOnConnected(conn -> {
            if (properties.isDnsCacheEnabled()) {
                conn.addHandlerFirst((ChannelHandler)new DnsCacheHandler(properties.getDnsTtl(), properties.getDnsNegativeTtl()));
            }
            conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)InfinityWebProperties.READ_TIMEOUT, TimeUnit.MILLISECONDS));
            conn.addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)InfinityWebProperties.WRITE_TIMEOUT, TimeUnit.MILLISECONDS));
        })).wiretap(properties.isWiretap()).keepAlive(properties.isKeepAlive());
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize(properties.getMaxInMemorySize() * 1024 * 1024)).build()).build();
    }

    @Bean
    public InfinityRestClient infinityRestClient(WebClient webClient) {
        return new InfinityRestClient(webClient);
    }

    @Bean
    @ConditionalOnClass
    public OAuth2Client oAuth2Client(RestWrapper restWrapper, RedisUtil redisUtil) {
        return new OAuth2Client(restWrapper, redisUtil);
    }

    @Bean(value={"phoenixRestTemplate"})
    @ConditionalOnMissingBean(name={"phoenixRestTemplate"})
    public RestTemplate phoenixRestTemplate() {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(InfinityWebProperties.RESPONSE_TIMEOUT);
        httpRequestFactory.setConnectTimeout(InfinityWebProperties.CONNECT_TIMEOUT);
        httpRequestFactory.setReadTimeout(InfinityWebProperties.READ_TIMEOUT);
        return new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
    }
}

