/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.weaver.e9.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.RSA;
import com.elitesland.cbpl.infinity.server.security.service.InfinitySecurityService;
import com.elitesland.cbpl.infinity.server.security.vo.param.InfinitySecuritySaveParamVO;
import com.elitesland.cbpl.infinity.server.security.vo.resp.InfinitySecurityDetailVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.convert.WeaverAccountConvert;
import com.elitesland.cbpl.infinity.web.security.service.weaver.domain.WeaverAccountVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.domain.WeaverRegisterVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.domain.WeaverTokenVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.service.WeaverE9Service;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util.WeaverE9Key;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util.WeaverE9Util;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.redis.util.RedisUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class WeaverE9ServiceImpl
implements WeaverE9Service {
    private static final Logger logger = LoggerFactory.getLogger(WeaverE9ServiceImpl.class);
    private final WebClient webClient;
    private final RedisUtil redisUtil;
    private final InfinitySecurityService securityService;

    @Override
    public void register(WeaverAccountVO accountVO) {
        InfinitySecuritySaveParamVO saveParam = WeaverAccountConvert.INSTANCE.voToSaveParam(accountVO);
        InfinitySecurityDetailVO detail = this.securityService.securityQueryOne(saveParam);
        if (ObjectUtil.isNull((Object)detail)) {
            this.createRSA(saveParam, accountVO);
            return;
        }
        String publicKey = detail.getLocalPublicKey();
        String privateKey = detail.getLocalPrivateKey();
        String spk = detail.getServerPublicKey();
        String secret = detail.getServerSecret();
        if (StrUtil.isBlank((CharSequence)publicKey) || StrUtil.isBlank((CharSequence)privateKey)) {
            RSA rsa = new RSA();
            publicKey = rsa.getPublicKeyBase64();
            privateKey = rsa.getPrivateKeyBase64();
        }
        if (StrUtil.isBlank((CharSequence)spk) || StrUtil.isBlank((CharSequence)secret)) {
            WeaverRegisterVO result = this.register(accountVO.getServerUrl(), accountVO.getAppid(), publicKey);
            spk = result.getSpk();
            secret = result.getSecret();
        }
        saveParam.setId(detail.getId());
        this.refresh(saveParam, accountVO.getPrefix(), publicKey, privateKey, spk, secret);
    }

    @Override
    public void refreshRegister(WeaverAccountVO accountVO) {
        InfinitySecuritySaveParamVO saveParam = WeaverAccountConvert.INSTANCE.voToSaveParam(accountVO);
        InfinitySecurityDetailVO detail = this.securityService.securityQueryOne(saveParam);
        if (ObjectUtil.isNull((Object)detail)) {
            LogUtil.info((String)"[BPMN][WEAVER-E9] \u672a\u6ce8\u518c\u8bb8\u53ef\u8bc1\uff0c\u4e0d\u652f\u6301\u5237\u65b0");
            throw new RuntimeException("\u672a\u6ce8\u518c\u8bb8\u53ef\u8bc1\uff0c\u4e0d\u652f\u6301\u5237\u65b0");
        }
        saveParam.setId(detail.getId());
        this.createRSA(saveParam, accountVO);
    }

    @Override
    public String getAccessToken(WeaverAccountVO accountVO) {
        String tokenKey = WeaverE9Util.tokenKey(accountVO.getAppid());
        String cacheToken = this.redisUtil.getString(tokenKey);
        if (ObjectUtil.isNotNull((Object)cacheToken)) {
            LogUtil.info((String)tokenKey, (String)"[BPMN][WEAVER-E9] \u7f13\u5b58Token: ", (Object)cacheToken);
            return cacheToken;
        }
        String spk = WeaverE9Key.getServerPublicKey(accountVO.getPrefix());
        String secret = WeaverE9Key.getServerSecret(accountVO.getPrefix());
        if (ObjectUtil.isNull((Object)secret) || ObjectUtil.isNull((Object)spk)) {
            this.register(accountVO);
            spk = WeaverE9Key.getServerPublicKey(accountVO.getPrefix());
            secret = WeaverE9Key.getServerSecret(accountVO.getPrefix());
        }
        String encryptSecret = WeaverE9Util.encrypt(accountVO.getPrefix(), secret);
        String resultStr = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(accountVO.getServerUrl() + "/api/ec/dev/auth/applytoken", new Object[0])).header("appid", new String[]{accountVO.getAppid()})).header("secret", new String[]{encryptSecret})).header("time", new String[]{accountVO.getTime()})).exchangeToMono(response -> response.bodyToMono(String.class)).block();
        if (StrUtil.isBlank((CharSequence)resultStr)) {
            LogUtil.info((String)tokenKey, (String)"[BPMN][WEAVER-E9] \u83b7\u53d6\u65b0Token\u5931\u8d25");
            throw new RuntimeException("[WEAVER] \u83b7\u53d6\u65b0Token\u5931\u8d25");
        }
        WeaverTokenVO result = (WeaverTokenVO)BeanUtils.toBean((String)resultStr, WeaverTokenVO.class);
        if (result.failed()) {
            LogUtil.info((String)tokenKey, (String)"[BPMN][WEAVER-E9] \u8ba4\u8bc1\u5f02\u5e38: ", (Object)result.getMsg());
            throw new RuntimeException("Weaver Auth error: " + result.getMsg());
        }
        LogUtil.info((String)tokenKey, (String)"[BPMN][WEAVER-E9] \u83b7\u53d6\u65b0Token: ", (Object)result.getToken());
        this.redisUtil.set(tokenKey, (Object)result.getToken(), accountVO.getExpiresIn(), TimeUnit.SECONDS);
        return result.getToken();
    }

    private void createRSA(InfinitySecuritySaveParamVO saveParam, WeaverAccountVO accountVO) {
        RSA rsa = new RSA();
        String publicKey = rsa.getPublicKeyBase64();
        String privateKey = rsa.getPrivateKeyBase64();
        WeaverRegisterVO registerVO = this.register(accountVO.getServerUrl(), accountVO.getAppid(), publicKey);
        this.refresh(saveParam, accountVO.getPrefix(), publicKey, privateKey, registerVO.getSpk(), registerVO.getSecret());
    }

    private WeaverRegisterVO register(String serverUrl, String appId, String publicKey) {
        String resultStr = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(serverUrl + "/api/ec/dev/auth/regist", new Object[0])).header("appid", new String[]{appId})).header("cpk", new String[]{publicKey})).exchangeToMono(response -> response.bodyToMono(String.class)).block();
        if (StrUtil.isBlank((CharSequence)resultStr)) {
            throw new RuntimeException("[WEAVER] \u6ce8\u518c\u8bb8\u53ef\u5931\u8d25");
        }
        return (WeaverRegisterVO)BeanUtils.toBean((String)resultStr, WeaverRegisterVO.class);
    }

    private void refresh(InfinitySecuritySaveParamVO saveParam, String prefix, String publicKey, String privateKey, String spk, String secret) {
        saveParam.setLocalPublicKey(publicKey);
        saveParam.setLocalPrivateKey(privateKey);
        saveParam.setServerPublicKey(spk);
        saveParam.setServerSecret(secret);
        this.securityService.save(saveParam);
        WeaverE9Key.setCache(prefix, spk, secret);
    }

    public WeaverE9ServiceImpl(WebClient webClient, RedisUtil redisUtil, InfinitySecurityService securityService) {
        this.webClient = webClient;
        this.redisUtil = redisUtil;
        this.securityService = securityService;
    }
}

