package com.elitesland.cbpl.infinity.web.common.vo;

import com.elitesland.cbpl.logging.infinity.domain.ResponseVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2021/07/19
 */
public abstract class InfinityResponseVO extends ResponseVO implements Serializable {

    private static final long serialVersionUID = -7204196611638488980L;

    /**
     * 链路跟踪ID
     */
    private String traceId;

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    /**
     * 接口返回码
     */
    public abstract String getCode();

    public abstract void setCode(String code);

    /**
     * 返回码说明
     */
    public abstract String getMessage();

    public abstract void setMessage(String message);

    /**
     * 数据集
     */
    public abstract List<Map<String, Object>> getData();

    public abstract void setData(List<Map<String, Object>> data);

    /**
     * 业务单据主键
     */
    public abstract String getBizKey();

    public abstract void setBizKey(String bizKey);

    public static <T extends InfinityResponseVO> T of(String code, String msg) {
        ResponseCommVO resp = new ResponseCommVO();
        resp.setCode(code);
        resp.setMessage(msg);
        return (T) resp;
    }

    public static <T extends InfinityResponseVO> T ok() {
        return InfinityResponseVO.of("S", "调用成功");
    }

    public static <T extends InfinityResponseVO> T error(String message) {
        return InfinityResponseVO.of("E", message);
    }

    public static <T extends InfinityResponseVO> T error() {
        return InfinityResponseVO.of("E", "内部错误，请联系管理员。");
    }

    public static <T extends InfinityResponseVO> T empty() {
        return InfinityResponseVO.of("E", "无数据");
    }

    @SneakyThrows
    public static <T extends InfinityResponseVO> T result(String response, Class<T> clazz) {
        return StringUtils.isBlank(response) ? InfinityResponseVO.empty() : BeanUtils.toBean(response, clazz);
    }

    /**
     * 是否成功获取到数据
     */
    public static boolean success(InfinityResponseVO res) {
        return success(res, "S");
    }

    public static boolean success(InfinityResponseVO res, String successCode) {
        return res != null && StringUtils.isNotBlank(res.getCode()) && successCode.equals(res.getCode());
    }

    public static boolean failed(InfinityResponseVO res) {
        return !success(res, "S");
    }

    public static boolean failed(InfinityResponseVO res, String successCode) {
        return !success(res, successCode);
    }
}
