package com.elitesland.cbpl.infinity.web.common.constant;

/**
 * @author eric.hao
 * @since 2023/08/17
 */
public interface InfinityStatus {

    /**
     * HTTP Status-Code 200: OK.
     */
    int OK = 200;

    /**
     * HTTP Status-Code 201: Created.
     */
    int CREATED = 201;

    /**
     * HTTP Status-Code 202: Accepted.
     */
    int ACCEPTED = 202;

    /**
     * HTTP Status-Code 203: Non-Authoritative Information.
     */
    int NOT_AUTHORITATIVE = 203;

    /**
     * HTTP Status-Code 204: No Content.
     */
    int NO_CONTENT = 204;

    /**
     * HTTP Status-Code 205: Reset Content.
     */
    int RESET = 205;

    /**
     * HTTP Status-Code 206: Partial Content.
     */
    int PARTIAL = 206;

    /* 3XX: relocation/redirect */

    /**
     * HTTP Status-Code 300: Multiple Choices.
     */
    int MULT_CHOICE = 300;

    /**
     * HTTP Status-Code 301: Moved Permanently.
     */
    int MOVED_PERM = 301;

    /**
     * HTTP Status-Code 302: Temporary Redirect.
     */
    int MOVED_TEMP = 302;

    /**
     * HTTP Status-Code 303: See Other.
     */
    int SEE_OTHER = 303;

    /**
     * HTTP Status-Code 304: Not Modified.
     */
    int NOT_MODIFIED = 304;

    /**
     * HTTP Status-Code 305: Use Proxy.
     */
    int USE_PROXY = 305;

    /* 4XX: client error */

    /**
     * HTTP Status-Code 400: Bad Request.
     */
    int BAD_REQUEST = 400;

    /**
     * HTTP Status-Code 401: Unauthorized.
     */
    int UNAUTHORIZED = 401;

    /**
     * HTTP Status-Code 402: Payment Required.
     */
    int PAYMENT_REQUIRED = 402;

    /**
     * HTTP Status-Code 403: Forbidden.
     */
    int FORBIDDEN = 403;

    /**
     * HTTP Status-Code 404: Not Found.
     */
    int NOT_FOUND = 404;

    /**
     * HTTP Status-Code 405: Method Not Allowed.
     */
    int BAD_METHOD = 405;

    /**
     * HTTP Status-Code 406: Not Acceptable.
     */
    int NOT_ACCEPTABLE = 406;

    /**
     * HTTP Status-Code 407: Proxy Authentication Required.
     */
    int PROXY_AUTH = 407;

    /**
     * HTTP Status-Code 408: Request Time-Out.
     */
    int CLIENT_TIMEOUT = 408;

    /**
     * HTTP Status-Code 409: Conflict.
     */
    int CONFLICT = 409;

    /**
     * HTTP Status-Code 410: Gone.
     */
    int GONE = 410;

    /**
     * HTTP Status-Code 411: Length Required.
     */
    int LENGTH_REQUIRED = 411;

    /**
     * HTTP Status-Code 412: Precondition Failed.
     */
    int PRECON_FAILED = 412;

    /**
     * HTTP Status-Code 413: Request Entity Too Large.
     */
    int ENTITY_TOO_LARGE = 413;

    /**
     * HTTP Status-Code 414: Request-URI Too Large.
     */
    int REQ_TOO_LONG = 414;

    /**
     * HTTP Status-Code 415: Unsupported Media Type.
     */
    int UNSUPPORTED_TYPE = 415;

    /* 5XX: server error */

    /**
     * HTTP Status-Code 500: Internal Server Error.
     */
    int INTERNAL_ERROR = 500;

    /**
     * HTTP Status-Code 501: Not Implemented.
     */
    int NOT_IMPLEMENTED = 501;

    /**
     * HTTP Status-Code 502: Bad Gateway.
     */
    int BAD_GATEWAY = 502;

    /**
     * HTTP Status-Code 503: Service Unavailable.
     */
    int UNAVAILABLE = 503;

    /**
     * HTTP Status-Code 504: Gateway Timeout.
     */
    int GATEWAY_TIMEOUT = 504;

    /**
     * HTTP Status-Code 505: HTTP Version Not Supported.
     */
    int VERSION = 505;
}
