package com.elitesland.cbpl.infinity.web.common.vo;

import cn.hutool.core.date.DateUtil;
import com.elitesland.cbpl.infinity.web.common.constant.InfinityStatus;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2023/09/19
 */
@Data
public class InfinityResult<T> implements Serializable {

    /**
     * 状态码
     */
    private int code;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 调用时间
     */
    private String time;

    /**
     * 链路追踪id
     */
    private String traceId;

    /**
     * 错误信息
     */
    private Object msg;

    /**
     * 响应数据
     */
    private T data;

    /**
     * 正常执行，补全其他信息
     */
    public void complete(String traceId) {
        if (code == 0) {
            this.setCode(InfinityStatus.OK);
        }
        this.setSuccess(successCode(code));
        this.setTime(DateUtil.now());
        this.setTraceId(traceId);
    }

    public static <T> InfinityResult<T> result(int code, T data, Object msg) {
        var result = new InfinityResult<T>();
        result.setCode(code);
        result.setSuccess(successCode(code));
        result.setTime(DateUtil.now());
        result.setMsg(msg);
        result.setData(data);
        return result;
    }

    public static <T> InfinityResult<T> ok() {
        return InfinityResult.ok(null);
    }

    public static <T> InfinityResult<T> ok(T data) {
        return InfinityResult.result(InfinityStatus.OK, data, null);
    }

    public static <T> InfinityResult<T> fail(Object msg) {
        return InfinityResult.fail(InfinityStatus.INTERNAL_ERROR, msg);
    }

    public static <T> InfinityResult<T> fail(int code, Object msg) {
        return InfinityResult.result(code, null, msg);
    }

    public static <T> InfinityResult<T> error(Throwable e) {
        return InfinityResult.fail(InfinityStatus.INTERNAL_ERROR, ExceptionUtils.formatException(e, 100));
    }

    private static boolean successCode(int code) {
        return code >= 200 && code < 300;
    }
}
