package com.elitesland.cbpl.infinity.web.http.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.tool.core.http.RestWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;

/**
 * @author eric.hao
 * @since 2023/04/19
 */
@Slf4j
@Component
public class InfinityRestClient {

    @Resource
    private RestWrapper restWrapper;

    /**
     * 统一接口调用
     *
     * @param param 接口请求参数
     * @param <T>   返回数据结果的实体类型
     * @param <K>   响应值的实体类型
     * @return 请求结果
     */
    public <T, K extends InfinityResponseVO> String exchange(HttpParam<T, K> param) {
        String responseStr;
        // GET
        if (param.getRequestMethod().equals(RequestMethod.GET)) {
            return restWrapper.get(param.getUrl(), param.getBodyMap(), param.getHeaders());
        }
        // POST
        else if (param.getRequestMethod().equals(RequestMethod.POST)) {
            //  form-data
            if (MediaType.MULTIPART_FORM_DATA.equals(param.getMediaType())) {
                responseStr = restWrapper.postFormData(param.getUrl(), param.getBodyMap(), param.getHeaders());
            }
            // x-www-form-urlencoded
            else if (MediaType.APPLICATION_FORM_URLENCODED.equals(param.getMediaType())) {
                responseStr = restWrapper.postFormUrlencoded(param.getUrl(), param.getBodyMap(), param.getHeaders());
            }
            // other: application/json
            else {
                responseStr = restWrapper.postJsonData(param.getUrl(), param.getBody(), param.getHeaders());
            }
            return responseStr;
        }
        throw new RuntimeException("[PHOENIX-INFINITY] only support: GET and POST.");
    }

    /**
     * 统一接口调用：做了结果集的对象简单封装
     *
     * @param param 接口请求参数
     * @param <T>   返回数据结果的实体类型
     * @param <K>   响应值的实体类型
     * @return 请求结果
     */
    public <T, K extends InfinityResponseVO> K exchangeToBean(HttpParam<T, K> param) {
        if (ObjectUtil.isNull(param.getResponseType())) {
            throw new RuntimeException("[PHOENIX-INFINITY] NULL OF RESPONSE_TYPE.");
        }
        return InfinityResponseVO.result(exchange(param), param.getResponseType());
    }
}
