/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.common.vo;

import cn.hutool.core.date.DateUtil;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import java.io.Serializable;

public class InfinityResult<T>
implements Serializable {
    private int code;
    private boolean success;
    private String time;
    private String traceId;
    private Object msg;
    private T data;

    public void complete(String traceId) {
        if (this.code == 0) {
            this.setCode(200);
        }
        this.setSuccess(InfinityResult.successCode(this.code));
        this.setTime(DateUtil.now());
        this.setTraceId(traceId);
    }

    public static <T> InfinityResult<T> result(int code, T data, Object msg) {
        InfinityResult<T> result = new InfinityResult<T>();
        result.setCode(code);
        result.setSuccess(InfinityResult.successCode(code));
        result.setTime(DateUtil.now());
        result.setMsg(msg);
        result.setData(data);
        return result;
    }

    public static <T> InfinityResult<T> ok() {
        return InfinityResult.ok(null);
    }

    public static <T> InfinityResult<T> ok(T data) {
        return InfinityResult.result(200, data, null);
    }

    public static <T> InfinityResult<T> fail(Object msg) {
        return InfinityResult.fail(500, msg);
    }

    public static <T> InfinityResult<T> fail(int code, Object msg) {
        return InfinityResult.result(code, null, msg);
    }

    public static <T> InfinityResult<T> error(Throwable e) {
        return InfinityResult.fail(500, ExceptionUtils.formatException((Throwable)e, (int)100));
    }

    private static boolean successCode(int code) {
        return code >= 200 && code < 300;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getTime() {
        return this.time;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Object getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setMsg(Object msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfinityResult)) {
            return false;
        }
        InfinityResult other = (InfinityResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Object this$msg = this.getMsg();
        Object other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfinityResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Object $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "InfinityResult(code=" + this.getCode() + ", success=" + this.isSuccess() + ", time=" + this.getTime() + ", traceId=" + this.getTraceId() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

