/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.http.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.tool.core.http.RestWrapper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class InfinityRestClient {
    private static final Logger log = LoggerFactory.getLogger(InfinityRestClient.class);
    @Resource
    private RestWrapper restWrapper;

    public <T, K extends InfinityResponseVO> String exchange(HttpParam<T, K> param) {
        if (param.getRequestMethod().equals((Object)RequestMethod.GET)) {
            return this.restWrapper.get(param.getUrl(), param.getBodyMap(), param.getHeaders());
        }
        if (param.getRequestMethod().equals((Object)RequestMethod.POST)) {
            String responseStr = MediaType.MULTIPART_FORM_DATA.equals((Object)param.getMediaType()) ? this.restWrapper.postFormData(param.getUrl(), param.getBodyMap(), param.getHeaders()) : (MediaType.APPLICATION_FORM_URLENCODED.equals((Object)param.getMediaType()) ? this.restWrapper.postFormUrlencoded(param.getUrl(), param.getBodyMap(), param.getHeaders()) : this.restWrapper.postJsonData(param.getUrl(), param.getBody(), param.getHeaders()));
            return responseStr;
        }
        throw new RuntimeException("[PHOENIX-INFINITY] only support: GET and POST.");
    }

    public <T, K extends InfinityResponseVO> K exchangeToBean(HttpParam<T, K> param) {
        if (ObjectUtil.isNull(param.getResponseType())) {
            throw new RuntimeException("[PHOENIX-INFINITY] NULL OF RESPONSE_TYPE.");
        }
        return InfinityResponseVO.result(this.exchange(param), param.getResponseType());
    }
}

