package com.elitesland.cbpl.logging.common.pipeline;

import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.adapter.SpecifyAdapter;
import com.elitesland.cbpl.unicom.annotation.Unicom;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/01/30
 */
@Unicom(adapter = SpecifyAdapter.class)
public interface PipelineService {

    /**
     * 消费(or持久化)方式
     *
     * @param property 配置
     * @param trackDoc 日志内容
     * @return 消费是否成功
     */
    boolean consume(LoggingProperty property, TrackDoc trackDoc);

    /**
     * 通用 - 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query);

    /**
     * 通用 - 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query);


    // ======================== 定制接口 ======================== //

    /**
     * 审计日志 - 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query);
}
