package com.elitesland.cbpl.logging.infinity.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.infinity.service.InfinityTrackService;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

/**
 * 系统日志 - 工具类
 *
 * @author eric.hao
 * @since 2023/08/17
 */
@Slf4j
@NoArgsConstructor
public class InfinityLogUtil {

    private static InfinityTrackService trackService;

    private static InfinityTrackService getInstance() {
        if (trackService == null) {
            trackService = SpringUtil.getBean(InfinityTrackService.class);
        }
        return trackService;
    }

    /**
     * 接口(被动)调用日志
     *
     * @param request      客户端请求
     * @param response     客户端响应
     * @param responseBody 接口返回结果
     */
    public static void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        getInstance().record(request, response, responseBody);
    }

    /**
     * 接口(主动)调用日志
     *
     * @param requestParam 接口请求参数
     * @param responseBody 接口返回结果
     * @param eventError   报错信息
     * @param spendTime    接口执行时长(秒)
     */
    public static void record(Object requestParam, Object responseBody, String eventError, double spendTime) {
        getInstance().record(requestParam, responseBody, eventError, spendTime);
    }
}
