package com.elitesland.cbpl.logging.syslog.service;

import com.elitesland.cbpl.logging.common.domain.TrackType;

/**
 * 系统日志
 *
 * @author eric.hao
 * @since 2023/06/13
 */
public interface SysLogService {

    /**
     * 系统日志
     *
     * @param event 业务类型(自定义传值)
     * @param param 业务参数
     */
    void info(String event, Object param);

    /**
     * 错误日志
     *
     * @param event 业务类型(自定义传值)
     * @param param 业务参数
     * @param ex    异常错误
     */
    void error(String event, Object param, Throwable ex);

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param event      业务类型(自定义传值)
     * @param param      业务参数
     * @param eventError 报错日志
     */
    void error(String event, Object param, String eventError);

    /**
     * 系统日志
     *
     * @param param 业务参数
     */
    default void info(Object param) {
        info(TrackType.LOG_SYSTEM.getCode(), param);
    }

    /**
     * 错误日志
     *
     * @param param 业务参数
     * @param ex    异常错误
     */
    default void error(Object param, Throwable ex) {
        error(TrackType.LOG_SYSTEM.getCode(), param, ex);
    }

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param param      业务参数
     * @param eventError 报错日志
     */
    default void error(Object param, String eventError) {
        error(TrackType.LOG_SYSTEM.getCode(), param, eventError);
    }
}
