package com.elitesland.cbpl.logging.syslog.service;

import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_SYSLOG_CFG;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
@Service
@RequiredArgsConstructor
public class SysLogServiceImpl implements SysLogService {

    private final PersistenceService persistenceService;

    @Override
    public void info(String event, Object param) {
        persistenceService.addSystemLog(LOG_SYSLOG_CFG, event, param, "");
    }

    @Override
    public void error(String event, Object param, Throwable ex) {
        persistenceService.addSystemLog(LOG_SYSLOG_CFG, event, param, ExceptionUtils.formatException(ex));
    }

    @Override
    public void error(String event, Object param, String eventError) {
        persistenceService.addSystemLog(LOG_SYSLOG_CFG, event, param, eventError);
    }
}
