package com.elitesland.cbpl.logging.syslog.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.service.SysLogService;
import com.elitesland.cbpl.logging.syslog.service.SysLogServiceImpl;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 系统日志 - 工具类
 *
 * @author eric.hao
 * @since 2023/08/17
 */
@Slf4j
@NoArgsConstructor
public class LogUtil {

    private static SysLogService sysLogService;

    private static SysLogService getInstance() {
        if (sysLogService == null) {
            sysLogService = SpringUtil.getBean(SysLogServiceImpl.class);
        }
        return sysLogService;
    }

    /**
     * 系统日志
     *
     * @param param 业务参数
     */
    public static void info(Object param) {
        getInstance().info(param);
    }

    /**
     * 错误日志
     *
     * @param eventError 报错日志
     */
    public static void error(String eventError) {
        getInstance().error(null, eventError);
    }

    /**
     * 错误日志
     *
     * @param param 业务参数
     * @param ex    异常错误
     */
    public static void error(Object param, Throwable ex) {
        getInstance().error(param, ex);
    }

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param param      业务参数
     * @param eventError 报错日志
     */
    public static void error(Object param, String eventError) {
        getInstance().error(param, eventError);
    }

    /**
     * 系统日志
     *
     * @param event 业务类型(自定义传值)
     * @param param 业务参数
     */
    public static void info(String event, Object param) {
        getInstance().info(event, param);
    }

    /**
     * 错误日志
     *
     * @param event 业务类型(自定义传值)
     * @param param 业务参数
     * @param ex    异常错误
     */
    public static void error(String event, Object param, Throwable ex) {
        getInstance().error(event, param, ex);
    }

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param event      业务类型(自定义传值)
     * @param param      业务参数
     * @param eventError 报错日志
     */
    public static void error(String event, Object param, String eventError) {
        getInstance().error(event, param, eventError);
    }
}
