package com.elitesland.cbpl.logging.infinity.service;

import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
public interface InfinityTrackService {

    /**
     * 接口(被动)调用日志
     *
     * @param request      客户端请求
     * @param response     客户端响应
     * @param responseBody 接口返回结果
     */
    void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody);

    /**
     * 接口(主动)调用日志
     *
     * @param requestParam 接口请求参数
     * @param responseBody 接口返回结果
     * @param eventError   报错信息
     * @param spendTime    接口执行时长(秒)
     */
    void record(Object requestParam, Object responseBody, String eventError, double spendTime);
}
