package com.elitesland.cbpl.logging.infinity.service;

import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_INFINITY_CFG;
import static com.elitesland.cbpl.logging.common.domain.TrackType.LOG_INFINITY_INVOKE;
import static com.elitesland.cbpl.logging.common.domain.TrackType.LOG_INFINITY_PASSIVE;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityTrackServiceImpl implements InfinityTrackService {

    private final PersistenceService persistenceService;

    /**
     * 接口(被动)调用日志
     */
    @Override
    public void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        ResponseWrapper responseWrapper = HttpServletUtil.wrapper(response);
        Map<String, Object> param = new HashMap<>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("RESPONSE_STATUS", responseWrapper.getStatus());
        param.put("RESPONSE_BODY", responseBody);
        persistenceService.addSystemLog(LOG_INFINITY_CFG, HttpServletUtil.wrapper(request), LOG_INFINITY_PASSIVE.getCode(), "[INFINITY] 接口(被动)调用日志", param, "");
    }

    /**
     * 接口(主动)调用日志
     */
    @Override
    public void record(Object requestParam, Object responseBody, String eventError, double spendTime) {
        Map<String, Object> param = new HashMap<>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("REQUEST_PARAM", requestParam);
        param.put("RESPONSE_BODY", responseBody);
        param.put("SPEND_TIME", spendTime);
        persistenceService.addSystemLog(LOG_INFINITY_CFG, LOG_INFINITY_INVOKE.getCode(), "[INFINITY] 接口(主动)调用日志", param, eventError);
    }
}
