package com.elitesland.cbpl.logging.audit.spi;

import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;

/**
 * SPI：操作日志本地处理
 *
 * @author eric.hao
 * @since 2023/08/29
 */
public interface AuditLogListener {

    /**
     * 获取操作者ID
     *
     * @return 操作者ID
     * @throws Exception 抛出异常
     */
    String getOperatorId() throws Exception;

    /**
     * 获取操作者姓名
     *
     * @return 操作者姓名
     * @throws Exception 抛出异常
     */
    String getOperatorName() throws Exception;

    /**
     * 自定义日志监听
     *
     * @param auditLogVO 日志传输实体
     * @return 监听结果：是否终止后续处理
     * @throws Exception 抛出异常
     */
    boolean createLog(AuditLogVO auditLogVO) throws Exception;

    /**
     * 本地操作日志处理失败处理器<br/>
     * 会在日志记录失败后被调用，若配置了重试次数，则超过重试次数后被调用
     */
    void operationLogGetErrorHandler();

    /**
     * 数据管道操作日志处理失败处理器<br/>
     * 会在日志记录失败后被调用，若配置了重试次数，则超过重试次数后被调用
     */
    void pipelineErrorHandler();
}
