package com.elitesland.cbpl.logging.common.pipeline.console.service;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/01/30
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("CONSOLE")
public class ConsolePipelineService implements PipelineService {

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            logger.info("[PHOENIX-LOG] CONSOLE({}): {}", trackDoc.getTrackType(), BeanUtils.toJsonStr(trackDoc));
            return true;
        } catch (Throwable throwable) {
            logger.error("[PHOENIX-LOG] persistence console error", throwable);
        }
        return false;
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        // do nothing.
        return new PagingVO<>();
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        // do nothing.
        return ListUtil.empty();
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        // do nothing.
        return ListUtil.empty();
    }
}
