package com.elitesland.cbpl.logging.common.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Supplier;

/**
 * @author eric.hao
 * @since 2024/02/04
 */
@Slf4j
public class LogConfigUtil {

    /**
     * 检查配置是否正确
     */
    public static void configIntegrity(LoggingProperty property) {
        if (ObjectUtil.isNull(property) || ObjectUtil.isNull(property.getLogType())) {
            throw PhoenixException.unchecked("[LOG] 日志类型未正确配置：" + BeanUtils.toJsonStr(property));
        }
        if (ObjectUtil.isNull(property.getConsumerPipeline())) {
            throw PhoenixException.unchecked("[LOG] 日志消费方式未指定：" + BeanUtils.toJsonStr(property));
        }
        String logType = property.getLogType().getCode();
        if (!property.isEnabled()) {
            throw PhoenixException.unchecked("[LOG] 日志功能未开启：" + logType);
        }
    }

    /**
     * 读取pipeline
     *
     * @param property 日志配置
     * @return 消费方式
     */
    public static String pipeline(LoggingProperty property) {
        LogConfigUtil.configIntegrity(property);
        return property.getConsumerPipeline().getCode();
    }

    /**
     * 执行指定的实现类
     */
    public static <T> T supply(Supplier<T> executor, LoggingProperty property) {
        return UnicomClient.supply(executor, pipeline(property));
    }
}
