/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.mysql.service;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.domain.TrackType;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.pipeline.mysql.entity.TrackDocDO;
import com.elitesland.cbpl.logging.common.pipeline.mysql.repo.MysqlTrackDocRepo;
import com.elitesland.cbpl.logging.common.pipeline.mysql.repo.MysqlTrackDocRepoProc;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@UnicomTag(value="MYSQL")
public class MysqlPipelineService
implements PipelineService {
    private static final Logger logger = LoggerFactory.getLogger(MysqlPipelineService.class);
    private final MysqlTrackDocRepo mysqlTrackDocRepo;
    private final MysqlTrackDocRepoProc mysqlTrackDocRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            TrackDocDO trackDocDO = this.saveParamToDO(trackDoc);
            this.mysqlTrackDocRepo.save(trackDocDO);
            return true;
        }
        catch (Throwable throwable) {
            logger.error("[PHOENIX-LOG] persistence mysql error", throwable);
            return false;
        }
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        long count = this.mysqlTrackDocRepoProc.trackDocCountBy(query);
        if (count > 0L) {
            List<TrackDocRespVO> list = this.mysqlTrackDocRepoProc.trackDocPageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        return this.mysqlTrackDocRepoProc.trackDocByParam(query);
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        TrackDocQueryParamVO queryParam = new TrackDocQueryParamVO();
        queryParam.setTrackType(TrackType.LOG_AUDIT.getCode());
        List<TrackDocRespVO> docs = this.trackDocByParam(queryParam);
        return docs.stream().map(doc -> (AuditLogVO)BeanUtils.toBean((String)doc.getEventParam(), AuditLogVO.class)).filter(row -> query.getBizTypes().contains(row.getBizType())).filter(row -> row.getBizId().equals(query.getBizId())).collect(Collectors.toList());
    }

    private TrackDocDO saveParamToDO(TrackDoc saveParam) {
        if (saveParam == null) {
            return null;
        }
        TrackDocDO trackDocDO = new TrackDocDO();
        if (saveParam.getCreateTime() != null) {
            LocalDateTime createTime = LocalDateTimeUtil.parse((CharSequence)saveParam.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            trackDocDO.setCreateTime(createTime);
        }
        trackDocDO.setTraceId(saveParam.getTraceId());
        trackDocDO.setRequestUrl(saveParam.getRequestUrl());
        trackDocDO.setRequestMethod(saveParam.getRequestMethod());
        trackDocDO.setRequestHeader(BeanUtils.toJsonOrEmpty((Object)saveParam.getRequestHeader()));
        trackDocDO.setRequestParams(BeanUtils.toJsonOrEmpty((Object)saveParam.getRequestParams()));
        trackDocDO.setRequestBody(BeanUtils.toJsonOrEmpty((Object)saveParam.getRequestBody()));
        trackDocDO.setResponseData(saveParam.getResponseData());
        trackDocDO.setTrackType(saveParam.getTrackType());
        trackDocDO.setAddressIp(saveParam.getAddressIp());
        trackDocDO.setEventParam(BeanUtils.toJsonOrEmpty((Object)saveParam.getEventParam()));
        trackDocDO.setErrorMessage(saveParam.getErrorMessage());
        return trackDocDO;
    }

    public MysqlPipelineService(MysqlTrackDocRepo mysqlTrackDocRepo, MysqlTrackDocRepoProc mysqlTrackDocRepoProc) {
        this.mysqlTrackDocRepo = mysqlTrackDocRepo;
        this.mysqlTrackDocRepoProc = mysqlTrackDocRepoProc;
    }
}

