package com.elitesland.cbpl.logging.infinity.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/05/20
 */
@Data
@ApiModel(value = "接口重放参数")
public class HttpReplayParam {

    @ApiModelProperty(value = "接口地址")
    private String url;

    @ApiModelProperty(value = "请求方式")
    @Enumerated(EnumType.STRING)
    private HttpMethod requestMethod;

    @ApiModelProperty(value = "认证方式")
    private String authMethod;

    @ApiModelProperty(value = "请求头的媒体类型")
    private String mediaType;

    @ApiModelProperty(value = "header参数")
    private MultiValueMap<String, String> headerParam;

    @ApiModelProperty(value = "查询参数")
    private MultiValueMap<String, String> queryParam;

    @ApiModelProperty(value = "路径参数")
    private Map<String, String> pathParam;

    @ApiModelProperty(value = "body参数")
    private Object bodyParam;
}
