package com.elitesland.cbpl.logging.syslog.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.elitesland.cbpl.logging.common.domain.TrackType;
import com.elitesland.cbpl.logging.syslog.domain.SysLogMessage;

/**
 * 线程内日志
 * 针对{@link LogUtil}做的二次封装
 *
 * @author eric.hao
 * @since 2023/08/28
 */
public class LogTrack {

    private static final TransmittableThreadLocal<SysLogMessage> SYS_LOG_MESSAGE = new TransmittableThreadLocal<>();


    private LogTrack() {
    }

    /**
     * 获取当前线程内记录的日志对象
     */
    public static SysLogMessage getMessages() {
        return SYS_LOG_MESSAGE.get();
    }

    /**
     * 日志对象初始化
     */
    public static void init() {
        LogTrack.init(TrackType.LOG_SYSTEM.getCode());
    }

    /**
     * 日志对象初始化
     *
     * @param trackType 业务类型(自定义传值)
     */
    public static void init(String trackType) {
        trackType = StrUtil.blankToDefault(trackType, TrackType.LOG_SYSTEM.getCode());
        SysLogMessage sysLogMessage = new SysLogMessage();
        sysLogMessage.setTrackType(trackType);
        SYS_LOG_MESSAGE.set(sysLogMessage);
    }

    /**
     * 增加一条日志内容
     */
    public static void add(String message) {
        SysLogMessage sysLogMessage = getMessages();
        sysLogMessage.add(message);
        SYS_LOG_MESSAGE.set(sysLogMessage);
    }

    /**
     * 日志提交 - 持久化保存
     */
    public static void commit() {
        SysLogMessage sysLogMessage = LogTrack.getMessages();
        LogUtil.info(sysLogMessage.getTrackType(), sysLogMessage.getMessages());
        SYS_LOG_MESSAGE.remove();
    }
}
