package com.elitesland.cbpl.logging.common.pipeline.mongo.domain;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.sql.Direction;
import cn.hutool.db.sql.Order;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.tool.mongo.repository.MongoQuery;
import lombok.Builder;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Query;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_AUDIT_CFG;
import static com.elitesland.cbpl.logging.common.domain.TrackType.LOG_AUDIT;
import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * 审计日志查询
 *
 * @author eric.hao
 * @since 2024/02/04
 */
@Slf4j
@Builder
@ToString
public class MongoAuditQuery extends MongoQuery {

    private final AuditQueryParamVO params;

    @Override
    public String getStoreName() {
        String storeName = LOG_AUDIT_CFG.getMongoStoreName();
        logger.debug("[MONGO] query use {}", storeName);
        return storeName;
    }

    /**
     * 缺省按时间倒序排列
     *
     * @param params 查询参数(为空表示无参数)
     */
    public MongoAuditQuery(AuditQueryParamVO params) {
        Order order = new Order();
        order.setDirection(Direction.DESC);
        order.setField("_id");
        super.setOrder(order);
        super.setPageNumber(params.getPageNumber());
        super.setPageSize(params.getPageSize());
        this.params = params;
    }

    @Override
    protected Query buildQuery() {
        Query query = new Query();
        query.addCriteria(where("trackType").in(LOG_AUDIT.getCode()));
        if (StrUtil.isNotBlank(params.getBizId())) {
            query.addCriteria(where("eventParam.bizId").is(params.getBizId()));
        }
        if (CollUtil.isNotEmpty(params.getBizTypes())) {
            query.addCriteria(where("eventParam.bizType").in(params.getBizTypes()));
        }
        return query;
    }
}
