package com.elitesland.cbpl.logging.syslog.domain;

import cn.hutool.core.collection.CollUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Data
@ApiModel("日志内容")
public class SysLogMessage {

    /**
     * 业务类型(自定义传值)
     */
    private String trackType;

    @ApiModelProperty("日志内容")
    private List<String> messages;

    /**
     * 添加一条日志内容
     *
     * @param message 日志内容
     */
    public void add(String message) {
        if (CollUtil.isEmpty(messages)) {
            messages = new ArrayList<>();
        }
        messages.add(message);
    }
}
