/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.audit.spi.AuditLogListener;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.tenant.TenantAsyncSpi;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import com.lzhpo.tracer.util.TracerUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class PersistenceServiceImpl
implements PersistenceService {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceServiceImpl.class);
    @Resource
    private TenantAsyncSpi tenantAsyncSpi;
    @Autowired(required=false)
    private AuditLogListener auditLogListener;
    private final PipelineService pipelineService;

    @Override
    public <T> void addSystemLogs(LoggingProperty property, String event, List<T> params, String eventError) {
        Consumer<Object> addSystemLog = param -> this.write(property, HttpServletUtil.currentRequestWrapper(), event, param, eventError);
        if (property.isThreadPool()) {
            if (this.tenantAsyncSpi == null) {
                params.forEach(addSystemLog);
            } else {
                this.tenantAsyncSpi.runAsync(() -> params.forEach(addSystemLog));
            }
        } else {
            params.forEach(addSystemLog);
        }
    }

    @Override
    public void addSystemLog(LoggingProperty property, String event, Object param, String eventError) {
        this.addSystemLog(property, HttpServletUtil.currentRequestWrapper(), event, param, eventError);
    }

    @Override
    public void addSystemLog(LoggingProperty property, RequestWrapper request, String event, Object param, String eventError) {
        if (property.isThreadPool()) {
            if (this.tenantAsyncSpi == null) {
                this.write(property, request, event, param, eventError);
            } else {
                this.tenantAsyncSpi.runAsync(() -> this.write(property, request, event, param, eventError));
            }
        } else {
            this.write(property, request, event, param, eventError);
        }
    }

    private void write(LoggingProperty property, RequestWrapper request, String event, Object param, String eventError) {
        if (ObjectUtil.isNull((Object)((Object)property.getLogType()))) {
            logger.error("[PHOENIX-LOG] EVENT({}) \u65e5\u5fd7\u7c7b\u578b\u672a\u6b63\u786e\u914d\u7f6e\uff1a{}", (Object)event, (Object)property);
            return;
        }
        if (ObjectUtil.isNull((Object)((Object)property.getConsumerPipeline()))) {
            logger.error("[PHOENIX-LOG] EVENT({}) \u65e5\u5fd7\u6d88\u8d39\u65b9\u5f0f\u672a\u6307\u5b9a\uff1a{}", (Object)event, (Object)property);
            return;
        }
        String logType = property.getLogType().getCode();
        String pipeline = property.getConsumerPipeline().getCode();
        if (!property.isEnabled()) {
            logger.warn("[PHOENIX-LOG] EVENT({}) {} \u529f\u80fd\u672a\u5f00\u542f.", (Object)event, (Object)logType);
            return;
        }
        TrackDoc trackDoc = new TrackDoc();
        if (ObjectUtil.isNotNull((Object)request)) {
            trackDoc.setRequestUrl(request.getRequestURL().toString());
            trackDoc.setRequestMethod(request.getMethod());
            trackDoc.setRequestHeader(HttpServletUtil.getHeaders((HttpServletRequest)request));
            trackDoc.setRequestParams(HttpServletUtil.getParameters((HttpServletRequest)request));
            trackDoc.setRequestBody(request.getBodyString());
            trackDoc.setAddressIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        }
        trackDoc.setTraceId(TracerUtils.getTraceId());
        trackDoc.setTrackType(event);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setEventParam(param);
        trackDoc.setErrorMessage(eventError);
        int maxRetryTimes = property.getRetry().getRetryTimes();
        boolean iOperationLogGetResult = false;
        if (this.auditLogListener != null && param instanceof AuditLogVO) {
            for (int retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
                try {
                    iOperationLogGetResult = this.auditLogListener.createLog((AuditLogVO)param);
                    if (!iOperationLogGetResult) continue;
                    break;
                }
                catch (Throwable throwable) {
                    logger.error("[PHOENIX-LOG] send auditLog error", throwable);
                }
            }
            if (!iOperationLogGetResult) {
                this.auditLogListener.operationLogGetErrorHandler();
            }
        }
        boolean pipelineServiceResult = false;
        for (int retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
            try {
                pipelineServiceResult = (Boolean)UnicomClient.supply(() -> this.pipelineService.consume(property, trackDoc), (String)pipeline);
                if (!pipelineServiceResult) continue;
                break;
            }
            catch (Throwable throwable) {
                logger.error("[PHOENIX-LOG] send persistence error", throwable);
            }
        }
        if (!pipelineServiceResult && this.auditLogListener != null) {
            this.auditLogListener.pipelineErrorHandler();
        }
    }

    public PersistenceServiceImpl(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }
}

