/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.infinity.service;

import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.domain.TrackType;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.logging.infinity.service.InfinityTrackService;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    private final PersistenceService persistenceService;

    @Override
    public void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        ResponseWrapper responseWrapper = HttpServletUtil.wrapper((ServerHttpResponse)response);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("RESPONSE_STATUS", responseWrapper.getStatus());
        param.put("RESPONSE_BODY", responseBody);
        this.persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, HttpServletUtil.wrapper((ServerHttpRequest)request), TrackType.LOG_INFINITY_PASSIVE.getCode(), param, "");
    }

    @Override
    public void record(Object requestParam, Object responseBody, String eventError, double spendTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("REQUEST_PARAM", requestParam);
        param.put("RESPONSE_BODY", responseBody);
        param.put("SPEND_TIME", spendTime);
        this.persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, TrackType.LOG_INFINITY_INVOKE.getCode(), param, eventError);
    }

    public InfinityTrackServiceImpl(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

