/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.syslog.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.service.SysLogService;
import com.elitesland.cbpl.logging.syslog.service.SysLogServiceImpl;
import com.lzhpo.tracer.TracerContextFactory;
import com.lzhpo.tracer.util.TracerUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class LogUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);
    private static SysLogService sysLogService;

    private static SysLogService getInstance() {
        if (sysLogService == null) {
            sysLogService = (SysLogService)SpringUtil.getBean(SysLogServiceImpl.class);
        }
        return sysLogService;
    }

    public static void info(Object param) {
        LogUtil.getInstance().info(param);
    }

    public static void error(String eventError) {
        LogUtil.getInstance().error(null, eventError);
    }

    public static void error(Object param, Throwable ex) {
        LogUtil.getInstance().error(param, ex);
    }

    public static void error(Object param, String eventError) {
        LogUtil.getInstance().error(param, eventError);
    }

    public static void info(String event, Object param) {
        LogUtil.getInstance().info(event, param);
    }

    public static void error(String event, Object param, Throwable ex) {
        LogUtil.getInstance().error(event, param, ex);
    }

    public static void error(String event, Object param, String eventError) {
        LogUtil.getInstance().error(event, param, eventError);
    }

    public static void initTraceId() {
        try {
            String traceId = TracerUtils.getTraceId();
            if (StrUtil.isBlank((CharSequence)traceId)) {
                TracerContextFactory tracer = (TracerContextFactory)SpringUtil.getBean(TracerContextFactory.class);
                tracer.setContext(new HashMap());
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-LOG] tracer log not enabled.");
        }
    }
}

