package com.elitesland.cbpl.logging.audit.annotation;

import java.lang.annotation.*;

/**
 * <p>
 * <strong>TIP: When using Java 8 or later, you can omit the @AuditLogs
 * wrapper annotation and directly specify several @AuditLog annotations on one method.</strong>
 *
 * <p>These two examples are equal.
 * </p>
 * <pre><code class='java'>
 * // before Java 8
 * &#64;AuditLogs({
 *     &#64;AuditLog(bizType = "'test1'", bizId = "#human.id", msg = "'修改跟进人' + #human.creator"),
 *     &#64;AuditLog(bizType = "'test2'", bizId = "#human.id", msg = "'修改跟进人' + #human.creator")
 * })
 * ApiResult<?> queryHuman(Human human);
 * </code></pre>
 * <pre><code class='java'>
 * // Java 8 and later
 * &#64;AuditLog(bizType = "'test1'", bizId = "#human.id", msg = "'修改跟进人' + #human.creator")
 * &#64;AuditLog(bizType = "'test2'", bizId = "#human.id", msg = "'修改跟进人' + #human.creator")
 * ApiResult<?> queryHuman(Human human);
 * </code></pre>
 *
 * @author eric.hao
 * @since 2023/08/29
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface AuditLogs {

    AuditLog[] value();
}